﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/OneColumn.master" CodeBehind="ProjectResources.aspx.cs" Inherits="GUI.Pages.ProjectResources" %>

<%@ Register TagPrefix="uc" Namespace="GUI.Controls" Assembly="GUI" %>


<asp:Content ID="Content3" ContentPlaceHolderID="Content" runat="server">

    <div class="page-full-main-content">
        <div class="row">
            <div class="col-md-12 col-sm-12">
            <div class="portlet light bordered light-blue">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Codes_ProjectResources %>" /> </span>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        <div class="form-body">
                        <div class="row">
                            <asp:HiddenField ID="hdnProjectId" runat="server" />
                            <asp:HiddenField ID="hdnTipResursa" runat="server" />
                            <asp:HiddenField ID="hdnProjectResourceId" runat="server" />
                                                    <asp:HiddenField ID="hdnId" runat="server" />
                            <asp:HiddenField ID="hdnSavePitanje" runat="server"/>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_ProjectResources %>" /></label>
                                    <div class="input-group">

                                        <telerik:RadAutoCompleteBox ID="radResourceAutocomplete" Skin="Bootstrap" OnEntryRemoved="radResourceAutocomplete_EntryRemoved" OnEntryAdded="radResourceAutocomplete_EntryAdded"  runat="server" Width="100%" DropDownHeight="150"   DropDownWidth="250"  MaxResultCount="3" OnClientEntryAdding="OnClientEntryAddingHandler" OnClientRequesting="requesting" >
								                <WebServiceSettings Method="GetResourcesForProject" Path="~/WebService/LoadEntities.asmx" />
							            </telerik:RadAutoCompleteBox>
                                        <span class="input-group-btn" style="top:-2px;">
                                           <asp:LinkButton ID="btnAddResource" OnClick="BtnAddClick" CssClass="btn blue" runat="server">
                                                <i class="fa fa-plus"></i>
                                            </asp:LinkButton>	
                                        </span>
                                    </div>
                                    <span class="help-block"><asp:RequiredFieldValidator ID="radResourceAutocompleteRequired"  ValidationGroup="Validacija" runat="server" Display="Dynamic"
                                CssClass="vError" SetFocusOnError="true" ControlToValidate="radResourceAutocomplete" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                                ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span>
                                    <!-- /input-group -->
                                </div>
                            </div>
                               <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal28" runat="server" Text="<%$ Resources:ProjectManagementUI, Codes_ResourceType %>" /></label>
                                            <telerik:RadTextBox Skin="Bootstrap" Width="100%"  ReadOnly="true" Font-Bold="True" runat="server" ID="txtResourceType">
                                            </telerik:RadTextBox>
                                </div>
                            </div>
                                                       <div class="col-md-2">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_ProjectResourcesValues %>" /></label>
                                            <telerik:RadComboBox Skin="Bootstrap" Width="100%"  Font-Bold="True" runat="server" ID="ddlValueList" AutoPostBack="true" OnSelectedIndexChanged="ddlValueList_SelectedIndexChanged" Enabled="true">
                                            </telerik:RadComboBox>
<span class="help-block"><asp:RequiredFieldValidator ID="RequiredFieldValidator3" ValidationGroup="Validacija" runat="server"  Display="Dynamic" SetFocusOnError="true" CssClass="vError"
														ControlToValidate="ddlValueList" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" InitialValue="<%$ Resources:ProjectManagementUI, Common_Choose %>"
														ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal27" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span>

                                </div>
                            </div>
                                 <div class="col-md-2">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Costs %>" /></label>
                                            <telerik:RadNumericTextBox Skin="Bootstrap" Width="100%"  NumberFormat-DecimalDigits="2" Font-Bold="True" runat="server" ID="txtCosts" CssClass="currency">
                                            </telerik:RadNumericTextBox>
                                </div>
                            </div>
                            

     <div class="col-md-2">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal6" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PlanedAmount %>" /></label>
                                            <telerik:RadNumericTextBox Skin="Bootstrap" Width="100%"  NumberFormat-DecimalDigits="2" Font-Bold="True" runat="server" ID="txtPlanedAmount" CssClass="currency">
                                            </telerik:RadNumericTextBox>
                     </div>
                            </div>
    </div>
    <div class="row">
                            <div class="col-md-12">
                                    <div class="form-actions right" style="border-top: none; margin-top: 4px;">
                                        <asp:Button ID="btnSave" ValidationGroup="Validacija" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                                runat="server" />
                                </div>
                            </div>
                        </div>
                            <div class="table-responsive">
                                <div class="col-md-6 text-left">
                                <asp:Button ID="btnExcel" OnClick="BtnExcelClick" CssClass="btn red" Text="Export Excel"
                                    runat="server" />
                            </div>
                                <telerik:RadGrid ID="grdProjectResources" runat="server" AutoPostBackOnFilter="true" OnItemCommand="grdProjectResourcestemCommand" AllowFilteringByColumn="true" CssClass="kendo-table" Skin="Bootstrap">
                                    <MasterTableView ShowHeadersWhenNoRecords="true" NoMasterRecordsText="<%$ Resources:ProjectManagementUI, Common_NoData %>"  CssClass="table table-striped table-hover"
                                        ShowFooter="False" AutoGenerateColumns="False" AllowFilteringByColumn="true" AllowCustomSorting="false"  DataKeyNames="Id" >
                                        <Columns>
                                            <telerik:GridBoundColumn UniqueName="IdColumn"  AllowFiltering="false" ShowFilterIcon="false" AutoPostBackOnFilter="true" HeaderText="Id" DataField="Id" />
                                            <telerik:GridBoundColumn UniqueName="ResourceColumn"  AllowFiltering="false" ShowFilterIcon="false" AutoPostBackOnFilter="true" SortExpression="resourcename" HeaderText="<%$ Resources:ProjectManagementUI, UI_ProjectResources %>"
                                                DataField="resourcename" />
                                            <telerik:GridBoundColumn UniqueName="ResourceTypeColumn"  AllowFiltering="true" ShowFilterIcon="false" AutoPostBackOnFilter="true" SortExpression="resourcetypenamelocalized" HeaderText="<%$ Resources:ProjectManagementUI, Codes_ResourceType %>"
                                                DataField="resourcetypenamelocalized" />
                                            <telerik:GridBoundColumn UniqueName="ValueColumn"  AllowFiltering="false" ShowFilterIcon="false" AutoPostBackOnFilter="true" SortExpression="value" HeaderText="<%$ Resources:ProjectManagementUI, UI_ProjectResourcesValues %>"
                                                DataField="valuecode" />
                                           <telerik:GridBoundColumn UniqueName="CostColumn"  AllowFiltering="false" ShowFilterIcon="false" AutoPostBackOnFilter="true" SortExpression="cost" HeaderText="<%$ Resources:ProjectManagementUI, Common_Costs %>"
                                                DataField="cost" />
                                           <telerik:GridBoundColumn UniqueName="PlanedColumn"  AllowFiltering="false" ShowFilterIcon="false" AutoPostBackOnFilter="true" SortExpression="PlanedAmount" HeaderText="<%$ Resources:ProjectManagementUI, Common_PlanedAmount %>"
                                                DataField="PlanedAmount" />
                                           <telerik:GridBoundColumn UniqueName="RealAmountColumn"  AllowFiltering="false" ShowFilterIcon="false" AutoPostBackOnFilter="true" SortExpression="RealAmountColumn" HeaderText="<%$ Resources:ProjectManagementUI, Common_ResourceConsumption %>"
                                                DataField="RealAmount" />
							                            <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderStyle-Width="5%" ButtonCssClass="btn btn-sm red" HeaderText="" ButtonType="LinkButton"
								                            Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>" ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>"/>
                                							                            <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" HeaderStyle-Width="5%" ButtonCssClass="btn btn-sm blue" HeaderText="" ButtonType="LinkButton"
								                            Text="<%$ Resources:ProjectManagementUI, Common_Edit %>" />
                                        </Columns>
                                    </MasterTableView>
                                </telerik:RadGrid>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
  <telerik:RadWindowManager ID="RadWindowManager1" runat="server">
                </telerik:RadWindowManager> 
    <script type="text/javascript">
        function requesting(sender, eventArgs) {
            //console.log(sender);
            //console.log(eventArgs.get_context());
            //alert(eventArgs.get_context());
	                var context = eventArgs.get_context();
	                //Data passed to the service.
	                //context["ProjectId"] = $('#<%= hdnProjectId.ClientID %>').val();
            //context["ProjectId"] = document.getElementsById('ctl00$ctl00$MainContentPlaceHolder$Content$hdnProjectId')[0].getAttribute('value');
            context["ProjectId"] = '<%= Request.QueryString["pid"] %>';    
	         }

	   function OnClientEntryAddingHandler(sender, eventArgs) {
	       //alert(sender.get_entries().get_count());
            if (sender.get_entries().get_count() == 1) {
                eventArgs.set_cancel(true);
                alert('<%= GetLexicalItem("Error_YouCanChooseOneActivity") %>');
            }
	     }
        function confirmCallBackFn(arg) {
                      var pitanje = document.getElementsByName("ctl00$ctl00$MainContentPlaceHolder$Content$hdnSavePitanje");
                
                if (arg == true) {
                    pitanje[0].setAttribute("value", "Moze");
                 }
                else {
                    pitanje[0].setAttribute("value", "NeceMoze");
                }
             }
        </script>
</asp:Content>